/*
 * Decompiled with CFR 0.152.
 */
package com.github.monun.survival.tap.event;

import com.github.monun.survival.tap.event.EntityEventManager;
import com.github.monun.survival.tap.event.EntityHandlerList;
import com.github.monun.survival.tap.event.EventEntity;
import com.github.monun.survival.tap.event.EventEntityProvider;
import com.github.monun.survival.tap.event.EventTools;
import com.github.monun.survival.tap.event.HandlerStatement;
import com.github.monun.survival.tap.event.ListenerStatement;
import com.github.monun.survival.tap.event.RegisteredEntityListener;
import com.google.common.collect.MapMaker;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.Server;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\"B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0015\u001a\u00020\u00142\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0018J\u0016\u0010!\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fRN\u0010\u0007\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000e\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\b\u0012\u00060\u0011R\u00020\u00000\u000fj\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\b\u0012\u00060\u0011R\u00020\u0000`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u00140\u000fj\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0012\u0004\u0012\u00020\u0014`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/github/monun/survival/tap/event/EntityEventManager;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "priority", "Lorg/bukkit/event/EventPriority;", "(Lorg/bukkit/plugin/Plugin;Lorg/bukkit/event/EventPriority;)V", "entities", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/bukkit/entity/Entity;", "kotlin.jvm.PlatformType", "Lcom/github/monun/survival/tap/event/EventEntity;", "eventExecutor", "Lorg/bukkit/plugin/EventExecutor;", "listeners", "Ljava/util/HashMap;", "Ljava/lang/Class;", "Lcom/github/monun/survival/tap/event/EntityEventManager$EventListener;", "Lkotlin/collections/HashMap;", "statements", "Lcom/github/monun/survival/tap/event/ListenerStatement;", "createRegisteredListenerStatement", "listenerClass", "registerEvent", "", "statement", "Lcom/github/monun/survival/tap/event/HandlerStatement;", "registerEvents", "Lcom/github/monun/survival/tap/event/RegisteredEntityListener;", "entity", "listener", "Lorg/bukkit/event/Listener;", "unregisterAll", "unregisterEvent", "EventListener", "api"})
public final class EntityEventManager {
    private final HashMap<Class<?>, ListenerStatement> statements;
    private final HashMap<Class<?>, EventListener> listeners;
    private final ConcurrentMap<Entity, EventEntity> entities;
    private final EventExecutor eventExecutor;
    private final Plugin plugin;
    private final EventPriority priority;

    @NotNull
    public final RegisteredEntityListener registerEvents(@NotNull Entity entity, @NotNull Listener listener2) {
        EventEntity eventEntity2;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        boolean bl = entity.isValid() || entity instanceof Player && ((Player)entity).isOnline();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Invalid entity: " + entity;
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        ListenerStatement listenerStatement = this.createRegisteredListenerStatement(listener2.getClass());
        EventEntity eventEntity3 = eventEntity2 = this.entities.computeIfAbsent(entity, registerEvents.eventEntity.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)eventEntity3, (String)"eventEntity");
        RegisteredEntityListener registeredEntityListener = new RegisteredEntityListener(eventEntity3, listenerStatement, listener2);
        eventEntity2.register(registeredEntityListener);
        return registeredEntityListener;
    }

    private final ListenerStatement createRegisteredListenerStatement(Class<?> listenerClass) {
        ListenerStatement listenerStatement = this.statements.computeIfAbsent(listenerClass, new Function<Class<?>, ListenerStatement>(this){
            final /* synthetic */ EntityEventManager this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ListenerStatement apply(@NotNull Class<?> clazz) {
                void var2_2;
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                ListenerStatement statement = ListenerStatement.Companion.getOrCreate(clazz);
                UnmodifiableIterator unmodifiableIterator = statement.getHandlerStatements().iterator();
                while (unmodifiableIterator.hasNext()) {
                    HandlerStatement statementStatement;
                    HandlerStatement handlerStatement = statementStatement = (HandlerStatement)unmodifiableIterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)handlerStatement, (String)"statementStatement");
                    EntityEventManager.access$registerEvent(this.this$0, handlerStatement);
                }
                return var2_2;
            }
            {
                this.this$0 = entityEventManager;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)listenerStatement, (String)"statements.computeIfAbse\u2026      statement\n        }");
        return listenerStatement;
    }

    private final void registerEvent(HandlerStatement statement) {
        Class<?> registrationClass = statement.getRegistrationClass();
        EventListener eventListener = this.listeners.computeIfAbsent(registrationClass, new Function<Class<?>, EventListener>(this){
            final /* synthetic */ EntityEventManager this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final EventListener apply(@NotNull Class<?> clazz) {
                void var2_2;
                Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
                EventListener newListener = this.this$0.new EventListener();
                Server server = EntityEventManager.access$getPlugin$p(this.this$0).getServer();
                Intrinsics.checkNotNullExpressionValue((Object)server, (String)"plugin.server");
                server.getPluginManager().registerEvent(clazz.asSubclass(Event.class), (Listener)newListener, EntityEventManager.access$getPriority$p(this.this$0), EntityEventManager.access$getEventExecutor$p(this.this$0), EntityEventManager.access$getPlugin$p(this.this$0), false);
                return var2_2;
            }
            {
                this.this$0 = entityEventManager;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)eventListener, (String)"listeners.computeIfAbsen\u2026    newListener\n        }");
        EventListener listener2 = eventListener;
        listener2.addProvider(statement.getProvider());
    }

    public final void unregisterEvent(@NotNull Entity entity, @NotNull Listener listener2) {
        ListenerStatement statement;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        EventEntity eventEntity2 = (EventEntity)this.entities.get(entity);
        if (eventEntity2 != null && (statement = this.statements.get(listener2.getClass())) != null) {
            eventEntity2.unregister(statement, listener2);
        }
    }

    public final void unregisterAll() {
        for (EventEntity eventEntity2 : this.entities.values()) {
            eventEntity2.unregisterAll();
        }
        for (EventListener listener2 : this.listeners.values()) {
            HandlerList.unregisterAll((Listener)listener2);
        }
        this.entities.clear();
        this.listeners.clear();
        this.statements.clear();
    }

    @JvmOverloads
    public EntityEventManager(@NotNull Plugin plugin, @NotNull EventPriority priority) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)priority, (String)"priority");
        this.plugin = plugin;
        this.priority = priority;
        this.statements = new HashMap();
        this.listeners = new HashMap();
        this.entities = new MapMaker().weakKeys().makeMap();
        this.eventExecutor = eventExecutor.1.INSTANCE;
    }

    public /* synthetic */ EntityEventManager(Plugin plugin, EventPriority eventPriority, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            eventPriority = EventPriority.NORMAL;
        }
        this(plugin, eventPriority);
    }

    @JvmOverloads
    public EntityEventManager(@NotNull Plugin plugin) {
        this(plugin, null, 2, null);
    }

    public static final /* synthetic */ void access$registerEvent(EntityEventManager $this, HandlerStatement statement) {
        $this.registerEvent(statement);
    }

    public static final /* synthetic */ Plugin access$getPlugin$p(EntityEventManager $this) {
        return $this.plugin;
    }

    public static final /* synthetic */ EventPriority access$getPriority$p(EntityEventManager $this) {
        return $this.priority;
    }

    public static final /* synthetic */ EventExecutor access$getEventExecutor$p(EntityEventManager $this) {
        return $this.eventExecutor;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011R\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u00050\bj\b\u0012\u0004\u0012\u00020\u0005`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/github/monun/survival/tap/event/EntityEventManager$EventListener;", "Lorg/bukkit/event/Listener;", "(Lcom/github/monun/tap/event/EntityEventManager;)V", "bake", "", "Lcom/github/monun/survival/tap/event/EventEntityProvider;", "[Lcom/github/monun/survival/tap/event/EventEntityProvider;", "providers", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "addProvider", "", "provider", "getBake", "()[Lcom/github/monun/tap/event/EventEntityProvider;", "onEvent", "event", "Lorg/bukkit/event/Event;", "api"})
    private final class EventListener
    implements Listener {
        private final LinkedHashSet<EventEntityProvider> providers = new LinkedHashSet();
        private EventEntityProvider[] bake;

        public final void onEvent(@NotNull Event event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            for (EventEntityProvider provider : this.getBake()) {
                EntityHandlerList handlers;
                EventEntity eventEntity2;
                Entity entity;
                Class<?> eventClass = event.getClass();
                if (!provider.getEventClass().isAssignableFrom(eventClass) || (entity = provider.getProvider().getFrom(event)) == null || (eventEntity2 = (EventEntity)EntityEventManager.this.entities.get(entity)) == null) continue;
                Class<?> regClass = EventTools.getRegistrationClass(eventClass);
                EntityHandlerList entityHandlerList = handlers = eventEntity2.getHandlerList(regClass);
                if (entityHandlerList == null) continue;
                entityHandlerList.callEvent(event, provider);
            }
        }

        private final EventEntityProvider[] getBake() {
            EventEntityProvider[] bake;
            EventEntityProvider[] eventEntityProviderArray = bake = this.bake;
            if (bake == null) {
                Collection $this$toTypedArray$iv = this.providers;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                EventEntityProvider[] eventEntityProviderArray2 = thisCollection$iv.toArray(new EventEntityProvider[0]);
                if (eventEntityProviderArray2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                EventEntityProvider[] eventEntityProviderArray3 = eventEntityProviderArray2;
                boolean bl = false;
                boolean bl2 = false;
                EventEntityProvider[] it = eventEntityProviderArray3;
                boolean bl3 = false;
                this.bake = it;
                eventEntityProviderArray = eventEntityProviderArray3;
            }
            return eventEntityProviderArray;
        }

        public final void addProvider(@NotNull EventEntityProvider provider) {
            Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
            this.providers.add(provider);
            this.bake = null;
        }
    }
}

